/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.stream.Stream;
import net.minecraft.client.resources.ClientLanguageMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.Language;
import net.minecraft.client.resources.data.LanguageMetadataSection;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.resources.IResourcePack;
import net.minecraft.util.text.LanguageMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LanguageManager
implements IResourceManagerReloadListener {
    private static final Logger field_147648_b = LogManager.getLogger();
    private static final Language field_239503_b_ = new Language("en_us", "US", "English", false);
    private Map<String, Language> field_135046_d = ImmutableMap.of((Object)"en_us", (Object)field_239503_b_);
    private String field_135048_c;
    private Language field_239504_e_ = field_239503_b_;

    public LanguageManager(String string) {
        this.field_135048_c = string;
    }

    private static Map<String, Language> func_239506_a_(Stream<IResourcePack> stream) {
        HashMap hashMap = Maps.newHashMap();
        stream.forEach(iResourcePack -> {
            try {
                LanguageMetadataSection languageMetadataSection = iResourcePack.func_195760_a(LanguageMetadataSection.field_195818_a);
                if (languageMetadataSection != null) {
                    for (Language language : languageMetadataSection.func_135018_a()) {
                        hashMap.putIfAbsent(language.getCode(), language);
                    }
                }
            }
            catch (IOException | RuntimeException exception) {
                field_147648_b.warn("Unable to parse language metadata section of resourcepack: {}", (Object)iResourcePack.func_195762_a(), (Object)exception);
            }
        });
        return ImmutableMap.copyOf((Map)hashMap);
    }

    @Override
    public void func_195410_a(IResourceManager iResourceManager) {
        this.field_135046_d = LanguageManager.func_239506_a_(iResourceManager.func_230232_b_());
        Language language = this.field_135046_d.getOrDefault("en_us", field_239503_b_);
        this.field_239504_e_ = this.field_135046_d.getOrDefault(this.field_135048_c, language);
        ArrayList \u26032 = Lists.newArrayList((Object[])new Language[]{language});
        if (this.field_239504_e_ != language) {
            \u26032.add(this.field_239504_e_);
        }
        ClientLanguageMap \u26033 = ClientLanguageMap.func_239497_a_(iResourceManager, \u26032);
        I18n.func_239502_a_(\u26033);
        LanguageMap.func_240594_a_(\u26033);
    }

    public void func_135045_a(Language language) {
        this.field_135048_c = language.getCode();
        this.field_239504_e_ = language;
    }

    public Language func_135041_c() {
        return this.field_239504_e_;
    }

    public SortedSet<Language> func_135040_d() {
        return Sets.newTreeSet(this.field_135046_d.values());
    }

    public Language func_191960_a(String string) {
        return this.field_135046_d.get(string);
    }
}

